RCRCVAR ;ALB/CMS - RC SERVER TYPE DRIVER VARIABLES  ;
V ;;4.5;Accounts Receivable;**61,63**;Mar 20, 1995
 ;;Per VHA Directive 10-93-142, this routine should not be modified.
 Q
CHK(RCTYP,RCSCE) ;
 ;Check for valid message sent to server
 ;Input: RCTYP - 4th $ piece of 1st line in server message
 ;               Server Code (RR1,RR2,OB,PP,FP,TR,...)
 ;       RCSCE - C;Conf., E;Error, O;ORIG. or UNK
 ;
 ;Output: DATA - Server Code^(C,E,O)^RCmailGroup^Desc.^SetXTMP,1or0^TaskRoutine
 ;        or
 ;        DATA - E;Error message, Server cannot understand the message
 ;
 N DATA,ERR,II,IN,LN,LT
 I ($G(RCTYP)="DR")!($G(RCTYP)="RR") S RCTYP=RCTYP_"1"
 S ERR="E;Server Code "_$G(RCTYP,"UNK")_" is not in a valid code."
 I (RCTYP="")!(RCSCE="UNK")!(RCTYP="UNK") S DATA=ERR G CHKQ
 S LT="RCTYP",DATA=""
 ;
 F II=1:1 D  Q:($G(DATA)]"")!($P(LN,";",3)="EOF")
   .S LN=$T(@LT+II)
   .I $P(LN,";",3)="EOF" Q
   .I RCTYP'=$P(LN,";",3) Q
   .I $P(LN,";",4)'[RCSCE Q
   .F IN=3:1:8 S $P(DATA,"^",IN-2)=$P(LN,";",IN)
   .Q
 ;
 I DATA="" S DATA=ERR
CHKQ Q DATA
 ;
RCTYP ;Valid RC Server Codes
 ; -3nd. piece is Server Code agreed by RC Programmer and CIO Programmer
 ; -4rd. piece is Type of message VAMC should receive for Server Code
 ;       (C)onfirmation, (E)rror or (O) if original data
 ; -5th. piece is the RC mail group to send to G. or S.
 ; -6th. piece is the mail subj. and/or description for XTMP
 ; -7th. piece is a 1 to set up XTMP or 0 not to set up XTMP
 ; -8th. piece is set to the DHCP routine for Server Code Type
 ;
 ;  G.RC RC REFERRALS - Mail group for users at RC and VAMC
 ;  S.RC RC SERV - RC Server No users.
 ;
 ;;RR1;CE;S.RC RC SERV;AR -REQUEST FOR RC RECONCILIATION (RI);0
 ;;RR2;CE;S.RC RC SERV;AR -REQUEST FOR RC RECONCILIATION (WC,NA,TF);0
 ;;DR1;O;S.RC RC SERV;AR -REFERRAL ROLLUP FROM RC FOR RECONCILIATION (RI);1;RCRCREC
 ;;DR2;O;S.RC RC SERV;AR -REFERRAL ROLLUP FROM RC FOR RECONCILIATION (WC,TF,NA);1;RCRCREC
 ;;MR1;CE;G.RC RC REFERRALS;AR -REFERRED BILLS IN VISTA, NOT REFERRED IN RC;0
 ;;MR2;CE;G.RC RC REFERRALS;AR -REFERRED BILLS IN RC, NOT REFERRED IN VISTA;0 
 ;;MR3;CE;G.RC RC REFERRALS;AR -REFERRED BILLS IN VISTA, NOT IN BALANCE WITH RC;0
 ;;MR4;CE;G.RC RC REFERRALS;AR -REFERRED BILLS WITH DECREASE BEFORE REFERRAL;0
 ;;OB;CE;S.RC RC SERV;AR -ORIG BILL REFERRAL TO RC;0
 ;;PP;CE;S.RC RC SERV;AR -PAYMENT IN PART TO RC;0
 ;;FP;CE;S.RC RC SERV;AR -PAYMENT IN FULL TO RC;0
 ;;IN;CE;S.RC RC SERV;AR -INCREASE ADJUSTMENT TO RC;0
 ;;TR;CE;S.RC RC SERV;AR -TRANSACTION HISTORY TO RC;0
 ;;TR;O;S.RC RC SERV;AR -TRANSACTION HISTORY REQUEST FROM RC;1;RCRCRT
 ;;CL;CE;S.RC RC SERV;AR -COMMENT LOG TO RC;0
 ;;CL;O;S.RC RC SERV;AR -COMMENT LOG REQUEST FROM RC;1;RCRCRT
 ;;RT;O;S.RC RC SERV;AR -RETURN REFERRED BILL FROM RC;1;RCRCRT
 ;;DA-1;O;S.RC RC SERV;AR -DECREASE ADJUSTMENT FROM RC;1;RCRCRT
 ;;DA-2;O;S.RC RC SERV;AR -DECREASE ADJUSTMENT FORM RC;1;RCRCRT
 ;;DA-3;O;S.RC RC SERV;AR -DECREASE ADJUSTMENT FROM RC;1;RCRCRT
 ;;DA-4;O;S.RC RC SERV;AR -DECREASE ADJUSTMENT FROM RC;1;RCRCRT
 ;;DA-5;O;S.RC RC SERV;AR -DECREASE ADJUSTMENT FROM RC;1;RCRCRT
 ;;DA-6;O;S.RC RC SERV;AR -DECREASE ADJUSTMENT FROM RC;1;RCRCRT
 ;;DA-7;O;S.RC RC SERV;AR -DECREASE ADJUSTMENT FROM RC;1;RCRCRT
 ;;DA-8;O;S.RC RC SERV;AR -DECREASE ADJUSTMENT FROM RC;1;RCRCRT
 ;;DA-9;O;S.RC RC SERV;AR -DECREASE ADJUSTMENT FROM RC;1;RCRCRT
 ;;DA-10;O;S.RC RC SERV;AR -DECREASE ADJUSTMENT FROM RC;1;RCRCRT
 ;;TJ-1;O;S.RC RC SERV;AR -WRITE OFF ADJUSTMENT FROM RC;1;RCRCRT
 ;;TJ-2;O;S.RC RC SERV;AR -WRITE OFF ADJUSTMENT FROM RC;1;RCRCRT
 ;;TJ-3;O;S.RC RC SERV;AR -WRITE OFF ADJUSTMENT FROM RC;1;RCRCRT
 ;;TJ-4;O;S.RC RC SERV;AR -WRITE OFF ADJUSTMENT FROM RC;1;RCRCRT
 ;;TJ-5;O;S.RC RC SERV;AR -WRITE OFF ADJUSTMENT FROM RC;1;RCRCRT
 ;;EOF
 Q
